<?php
/**
 * cadastrar_artista.php
 * Baseado no editar_artista.php (mesmo padrão de includes + layout)
 *
 * Fluxo:
 * - Exibe formulário vazio
 * - Envia para salvar_artista.php com um campo hidden acao=criar
 */

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

/**
 * Paths
 */
$includes_path = '/home/tomverascom/public_html/artistas-de-blues/includes/';
$adex_includes = __DIR__ . '/../includes_adex/';

/**
 * Config do ADEX (DB_HOST etc)
 */
if (!defined('DB_HOST')) {
  include_once($adex_includes . 'config.php');
}

/**
 * DB (usa $conn)
 */
include_once($includes_path . 'db_connect.php');

/**
 * Header + Menu do ADEX
 */
include_once($adex_includes . 'header.php');
include_once($adex_includes . 'menu_adex.php');

$mensagem = '';

/**
 * Se quiser, dá pra checar se slug já existe via GET ?slug=...
 * (não obrigatório; aqui fica só um aviso simples)
 */
if (!empty($_GET['jaexiste'])) {
  $mensagem = "Já existe um artista com esse URL amigável. Tente outro.";
}
?>

<div class="container mt-4 mb-5">
  <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between gap-2 mb-3">
    <div>
      <h2 class="mb-0">Cadastrar Artista</h2>
      <div class="text-muted">Crie um novo registro na tabela <code>artistas</code>.</div>
    </div>
  </div>

  <?php if (!empty($mensagem)): ?>
    <div class="alert alert-warning"><?= htmlspecialchars($mensagem) ?></div>
  <?php endif; ?>

  <form action="salvar_artista.php" method="post" enctype="multipart/form-data">
    <input type="hidden" name="acao" value="criar">

    <div class="mb-3">
      <label class="form-label">Nome do Artista</label>
      <input type="text" name="nome_artista" class="form-control" value="" required>
    </div>

    <div class="mb-3">
      <label class="form-label">URL Amigável (slug)</label>
      <input type="text" name="url_amigavel" class="form-control" value="" required>
      <div class="form-text">Ex.: <code>big-mama-thornton</code> (sem espaços, sem acento)</div>
    </div>

    <div class="mb-3">
      <label class="form-label">Data de Nascimento</label>
      <input type="date" name="data_nascimento" class="form-control" value="">
    </div>

    <div class="mb-3">
      <label class="form-label">Data de Falecimento</label>
      <input type="date" name="data_falecimento" class="form-control" value="">
    </div>

    <div class="mb-3">
      <label class="form-label">Instagram</label>
      <input type="url" name="url_instagram" class="form-control" value="" placeholder="https://instagram.com/...">
    </div>

    <div class="mb-3">
      <label class="form-label">YouTube (Vídeo principal)</label>
      <input type="url" name="url_youtube" class="form-control" value="" placeholder="https://www.youtube.com/watch?v=...">
    </div>

    <div class="mb-3">
      <label class="form-label">YouTube Shorts</label>
      <input type="url" name="url_youtube_shorts" class="form-control" value="" placeholder="https://www.youtube.com/shorts/...">
    </div>

    <div class="mb-3">
      <label class="form-label">Conteúdo (HTML)</label>
      <textarea name="conteudo" class="form-control" rows="8" placeholder="Cole aqui o HTML do conteúdo..."></textarea>
    </div>

    <div class="mb-3">
      <label class="form-label">Foto Principal (nome do arquivo)</label>
      <input type="text" name="foto_principal" class="form-control" value="" placeholder="ex: big-mama.jpg">
    </div>

    <div class="mb-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="publicado" selected>Publicado</option>
        <option value="arquivado">Arquivado</option>
      </select>
    </div>

    <div class="d-flex gap-2">
      <button type="submit" class="btn btn-primary">Cadastrar</button>
      <a href="/pages_adex/listar_artistas.php" class="btn btn-outline-secondary">Voltar</a>
    </div>
  </form>
</div>

<?php include_once($adex_includes . 'footer.php'); ?>
