<?php


/**
 * Paths
 */
$includes_path = '/home/tomverascom/public_html/artistas-de-blues/includes/';
$adex_includes = __DIR__ . '/../includes_adex/';

/**
 * Config do ADEX (DB_HOST etc)
 */
if (!defined('DB_HOST')) {
  include_once($adex_includes . 'config.php');
}

/**
 * DB (usa $conn)
 */
include_once($includes_path . 'db_connect.php');

/**
 * Header + Menu do ADEX
 */
include_once($adex_includes . 'header.php');
include_once($adex_includes . 'menu_adex.php');

/**
 * Obter slug da URL
 */
$url_amigavel = isset($_GET['artista']) ? trim($conn->real_escape_string($_GET['artista'])) : '';

if (empty($url_amigavel)) {
  echo "<div class='container mt-5'><h2>Artista não encontrado.</h2></div>";
  exit;
}

// Buscar dados do artista
$stmt = $conn->prepare("SELECT * FROM artistas WHERE url_amigavel = ? LIMIT 1");
$stmt->bind_param("s", $url_amigavel);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
  echo "<div class='container mt-5'><h2>Artista não encontrado.</h2></div>";
  exit;
}

$artista = $result->fetch_assoc();

function formatar_data_input($data) {
  return (!empty($data) && $data !== '0000-00-00') ? date('Y-m-d', strtotime($data)) : '';
}
?>

<div class="container mt-4 mb-5">
  <h2 class="mb-4">Editar Artista: <?= htmlspecialchars($artista['nome_artista']) ?></h2>

  <form action="salvar_artista.php" method="post" enctype="multipart/form-data">
    <input type="hidden" name="id_artista" value="<?= (int)$artista['id_artista'] ?>">

    <div class="mb-3">
      <label class="form-label">Nome do Artista</label>
      <input type="text" name="nome_artista" class="form-control" value="<?= htmlspecialchars($artista['nome_artista']) ?>" required>
    </div>

    <div class="mb-3">
      <label class="form-label">URL Amigável</label>
      <input type="text" name="url_amigavel" class="form-control" value="<?= htmlspecialchars($artista['url_amigavel']) ?>" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Data de Nascimento</label>
      <input type="date" name="data_nascimento" class="form-control" value="<?= formatar_data_input($artista['data_nascimento']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">Data de Falecimento</label>
      <input type="date" name="data_falecimento" class="form-control" value="<?= formatar_data_input($artista['data_falecimento']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">Instagram</label>
      <input type="url" name="url_instagram" class="form-control" value="<?= htmlspecialchars($artista['url_instagram']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">YouTube (Vídeo principal)</label>
      <input type="url" name="url_youtube" class="form-control" value="<?= htmlspecialchars($artista['url_youtube']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">YouTube Shorts</label>
      <input type="url" name="url_youtube_shorts" class="form-control" value="<?= htmlspecialchars($artista['url_youtube_shorts']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">Conteúdo (HTML)</label>
      <textarea name="conteudo" class="form-control" rows="8"><?= htmlspecialchars($artista['conteudo']) ?></textarea>
    </div>

    <div class="mb-3">
      <label class="form-label">Foto Principal (nome do arquivo)</label>
      <input type="text" name="foto_principal" class="form-control" value="<?= htmlspecialchars($artista['foto_principal']) ?>">
    </div>

    <div class="mb-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="publicado" <?= $artista['status'] === 'publicado' ? 'selected' : '' ?>>Publicado</option>
        <option value="arquivado" <?= $artista['status'] === 'arquivado' ? 'selected' : '' ?>>Arquivado</option>
      </select>
    </div>

    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
  </form>
</div>

