<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$mensagem = '';
$aula = null;

// Se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $id > 0) {
  $sequencia = (isset($_POST['sequencia']) && $_POST['sequencia'] !== '') ? (int) $_POST['sequencia'] : null;

  $titulo = $_POST['titulo'] ?? '';
  $texto = $_POST['texto'] ?? '';
  $link_youtube = $_POST['link_youtube'] ?? '';
  $bibliografia = $_POST['bibliografia'] ?? '';
  $fonte = $_POST['fonte'] ?? '';

  $periodo_inicial = (isset($_POST['periodo_inicial']) && $_POST['periodo_inicial'] !== '') ? (int) $_POST['periodo_inicial'] : null;
  $periodo_final   = (isset($_POST['periodo_final']) && $_POST['periodo_final'] !== '') ? (int) $_POST['periodo_final'] : null;

  $artistas_relacionados = $_POST['artistas_relacionados'] ?? '';
  $relacionado_a = isset($_POST['relacionado_a']) && is_array($_POST['relacionado_a'])
    ? implode(',', $_POST['relacionado_a'])
    : '';

  $stmt = $conn->prepare(
    "UPDATE aulas
     SET sequencia = ?,
         titulo = ?,
         texto = ?,
         link_youtube = ?,
         bibliografia = ?,
         fonte = ?,
         periodo_inicial = ?,
         periodo_final = ?,
         artistas_relacionados = ?,
         relacionado_a = ?
     WHERE id_aulas = ?"
  );

  if ($stmt) {
    // i = int (aceita NULL), s = string
    $stmt->bind_param(
      "isssssiissi",
      $sequencia,
      $titulo,
      $texto,
      $link_youtube,
      $bibliografia,
      $fonte,
      $periodo_inicial,
      $periodo_final,
      $artistas_relacionados,
      $relacionado_a,
      $id
    );

    if ($stmt->execute()) {
      $mensagem = '<div class="alert alert-success">Aula atualizada com sucesso!</div>';
    } else {
      $mensagem = '<div class="alert alert-danger">Erro ao atualizar: ' . htmlspecialchars($stmt->error ?? '') . '</div>';
    }

    $stmt->close();
  } else {
    $mensagem = '<div class="alert alert-danger">Erro ao preparar UPDATE.</div>';
  }
}

// Carregar dados da aula
if ($id > 0) {
  $stmt = $conn->prepare("SELECT * FROM aulas WHERE id_aulas = ?");
  if ($stmt) {
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $resultado = $stmt->get_result();
    $aula = $resultado->fetch_assoc();
    $stmt->close();

    if (!$aula) {
      $mensagem = '<div class="alert alert-warning">Aula não encontrada.</div>';
    }
  } else {
    $mensagem = '<div class="alert alert-danger">Erro ao preparar SELECT.</div>';
  }
} else {
  $mensagem = '<div class="alert alert-warning">ID inválido.</div>';
}

$form_action = basename($_SERVER['PHP_SELF']) . '?id=' . (int) $id;
?>

<div class="container my-4">
  <h2 class="mb-4">Editar Aula</h2>

  <?= $mensagem ?>

  <?php if ($aula): ?>
    <form method="post" action="<?= htmlspecialchars($form_action ?? '') ?>">
      <div class="mb-3">
        <label for="sequencia" class="form-label">Sequência</label>
        <input type="number" class="form-control" id="sequencia" name="sequencia"
               value="<?= htmlspecialchars($aula['sequencia'] ?? '') ?>">
      </div>

      <div class="mb-3">
        <label for="titulo" class="form-label">Título da Aula *</label>
        <input type="text" class="form-control" id="titulo" name="titulo" required
               value="<?= htmlspecialchars($aula['titulo'] ?? '') ?>">
      </div>

      <div class="mb-3">
        <label for="texto" class="form-label">Texto da Aula</label>
        <textarea class="form-control" id="texto" name="texto" rows="6"><?= htmlspecialchars($aula['texto'] ?? '') ?></textarea>
      </div>

      <div class="mb-3">
        <label for="link_youtube" class="form-label">Link do YouTube</label>
        <input type="url" class="form-control" id="link_youtube" name="link_youtube"
               value="<?= htmlspecialchars($aula['link_youtube'] ?? '') ?>">
      </div>

      <div class="mb-3">
        <label for="bibliografia" class="form-label">Bibliografia</label>
        <textarea class="form-control" id="bibliografia" name="bibliografia" rows="4"><?= htmlspecialchars($aula['bibliografia'] ?? '') ?></textarea>
      </div>

      <div class="mb-3">
        <label for="fonte" class="form-label">Fonte</label>
        <input type="text" class="form-control" id="fonte" name="fonte"
               value="<?= htmlspecialchars($aula['fonte'] ?? '') ?>">
      </div>

      <div class="mb-3">
        <label for="periodo_inicial" class="form-label">Período Inicial (Ano)</label>
        <input type="number" class="form-control" id="periodo_inicial" name="periodo_inicial"
               value="<?= htmlspecialchars($aula['periodo_inicial'] ?? '') ?>" min="1000" max="9999">
      </div>

      <div class="mb-3">
        <label for="periodo_final" class="form-label">Período Final (Ano)</label>
        <input type="number" class="form-control" id="periodo_final" name="periodo_final"
               value="<?= htmlspecialchars($aula['periodo_final'] ?? '') ?>" min="1000" max="9999">
      </div>

      <div class="mb-3">
        <label for="artistas_relacionados" class="form-label">Artistas Relacionados (IDs separados por vírgula)</label>
        <input type="text" class="form-control" id="artistas_relacionados" name="artistas_relacionados"
               value="<?= htmlspecialchars($aula['artistas_relacionados'] ?? '') ?>">
      </div>

      <div class="mb-3">
        <label class="form-label">Relacionado a</label>
        <?php
          $relacionado = array_filter(array_map('trim', explode(',', (string)($aula['relacionado_a'] ?? ''))));
          $opcoes = ['historia', 'estoria', 'cultura', 'epoca', 'outros'];
        ?>
        <?php foreach ($opcoes as $op): ?>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="relacionado_a[]" value="<?= htmlspecialchars($op ?? '') ?>"
                   id="<?= htmlspecialchars($op ?? '') ?>" <?= in_array($op, $relacionado, true) ? 'checked' : '' ?>>
            <label class="form-check-label" for="<?= htmlspecialchars($op ?? '') ?>"><?= htmlspecialchars(ucfirst($op) ?? '') ?></label>
          </div>
        <?php endforeach; ?>
      </div>

      <button type="submit" class="btn btn-primary">Salvar Alterações</button>
    </form>
  <?php endif; ?>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
