<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

// Configuração da paginação
$limite = 20;
$pagina = (isset($_GET['pagina']) && is_numeric($_GET['pagina']) && (int)$_GET['pagina'] > 0) ? (int) $_GET['pagina'] : 1;
$offset = ($pagina - 1) * $limite;

// Total de registros
$total_registros = 0;
$total_paginas = 1;

$stmtTotal = $conn->prepare("SELECT COUNT(*) AS total FROM aulas");
if ($stmtTotal) {
  $stmtTotal->execute();
  $result_total = $stmtTotal->get_result();
  $row_total = $result_total ? $result_total->fetch_assoc() : null;
  $total_registros = (int) ($row_total['total'] ?? 0);
  $stmtTotal->close();
}
$total_paginas = max(1, (int) ceil($total_registros / $limite));

// Buscar os dados
$result = null;
$stmt = $conn->prepare("SELECT id_aulas, titulo, sequencia, relacionado_a FROM aulas ORDER BY sequencia ASC LIMIT ? OFFSET ?");
if ($stmt) {
  $stmt->bind_param("ii", $limite, $offset);
  $stmt->execute();
  $result = $stmt->get_result();
  // não fecha aqui se quiser iterar com $result; ok fechar após o loop
}
?>

<div class="container my-4">
  <h2 class="mb-4">Aulas Cadastradas</h2>

  <table class="table table-bordered table-hover">
    <thead class="table-light">
      <tr>
        <th>Título</th>
        <th>Sequência</th>
        <th>Relacionado a</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result && $result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td>
              <a href="exibe_aula.php?id=<?= (int) ($row['id_aulas'] ?? 0) ?>">
                <?= htmlspecialchars($row['titulo'] ?? '') ?>
              </a>
            </td>
            <td><?= htmlspecialchars($row['sequencia'] ?? '') ?></td>
            <td><?= htmlspecialchars($row['relacionado_a'] ?? '') ?></td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr>
          <td colspan="3" class="text-center">Nenhuma aula cadastrada.</td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>

  <?php
  if (isset($stmt) && $stmt) {
    $stmt->close();
  }
  ?>

  <!-- Paginação -->
  <?php if ($total_paginas > 1): ?>
    <nav>
      <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
          <li class="page-item <?= ($i === $pagina) ? 'active' : '' ?>">
            <a class="page-link" href="?pagina=<?= (int) $i ?>"><?= (int) $i ?></a>
          </li>
        <?php endfor; ?>
      </ul>
    </nav>
  <?php endif; ?>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
