<?php
// ADEX config (se necessário)
if (!defined('DB_HOST')) {
  include_once(__DIR__ . '/../includes_adex/config.php');
}

// DB do site público
include_once('/home/tomverascom/public_html/artistas-de-blues/includes/db_connect.php');

// Header e menu do ADEX
include_once(__DIR__ . '/../includes_adex/header.php');
include_once(__DIR__ . '/../includes_adex/menu_adex.php');

// Parâmetros de ordenação
$ordenar_por = isset($_GET['ordenar']) ? (string) $_GET['ordenar'] : 'nome_artista';
$direcao = (isset($_GET['dir']) && $_GET['dir'] === 'desc') ? 'DESC' : 'ASC';
$proxima_direcao = ($direcao === 'ASC') ? 'desc' : 'asc';

// Validação dos campos permitidos
$ordenacoes_validas = ['nome_artista', 'data_nascimento', 'data_falecimento'];
if (!in_array($ordenar_por, $ordenacoes_validas, true)) {
  $ordenar_por = 'nome_artista';
}

// Paginação
$por_pagina = 20;
$pagina = (isset($_GET['pagina']) && is_numeric($_GET['pagina']) && (int)$_GET['pagina'] > 0) ? (int) $_GET['pagina'] : 1;
$inicio = ($pagina - 1) * $por_pagina;

// Total de registros
$total_artistas = 0;
$stmtTotal = $conn->prepare("SELECT COUNT(*) as total FROM artistas");
if ($stmtTotal) {
  $stmtTotal->execute();
  $resTotal = $stmtTotal->get_result();
  $rowTotal = $resTotal ? $resTotal->fetch_assoc() : null;
  $total_artistas = (int) ($rowTotal['total'] ?? 0);
  $stmtTotal->close();
}
$total_paginas = max(1, (int) ceil($total_artistas / $por_pagina));

// Consulta principal com ordenação (coluna validada acima)
$sql = "SELECT id_artista, nome_artista, url_amigavel, data_nascimento, data_falecimento, status
        FROM artistas
        ORDER BY $ordenar_por $direcao
        LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);
$result = null;
if ($stmt) {
  $stmt->bind_param("ii", $por_pagina, $inicio);
  $stmt->execute();
  $result = $stmt->get_result();
}
?>

<div class="container mt-4 mb-5">
  <h2 class="mb-4">Artistas – Página <?= (int) $pagina ?></h2>

  <table class="table table-bordered table-striped">
    <thead class="table-light">
      <tr>
        <th>ID</th>
        <th>
          <a href="?ordenar=nome_artista&dir=<?= ($ordenar_por === 'nome_artista') ? $proxima_direcao : 'asc' ?>&pagina=<?= (int) $pagina ?>">
            Nome <?= ($ordenar_por === 'nome_artista') ? ($direcao === 'ASC' ? '▲' : '▼') : '' ?>
          </a>
        </th>
        <th>
          <a href="?ordenar=data_nascimento&dir=<?= ($ordenar_por === 'data_nascimento') ? $proxima_direcao : 'asc' ?>&pagina=<?= (int) $pagina ?>">
            Nascimento <?= ($ordenar_por === 'data_nascimento') ? ($direcao === 'ASC' ? '▲' : '▼') : '' ?>
          </a>
        </th>
        <th>
          <a href="?ordenar=data_falecimento&dir=<?= ($ordenar_por === 'data_falecimento') ? $proxima_direcao : 'asc' ?>&pagina=<?= (int) $pagina ?>">
            Falecimento <?= ($ordenar_por === 'data_falecimento') ? ($direcao === 'ASC' ? '▲' : '▼') : '' ?>
          </a>
        </th>
        <th>Status</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result && $result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= (int) ($row['id_artista'] ?? 0) ?></td>
            <td>
              <a href="editar_artista.php?artista=<?= urlencode((string)($row['url_amigavel'] ?? '')) ?>">
                <?= htmlspecialchars($row['nome_artista'] ?? '') ?>
              </a>
            </td>
            <td>
              <?php
              $dn = $row['data_nascimento'] ?? '';
              echo (!empty($dn) && $dn !== '0000-00-00') ? htmlspecialchars(date('d/m/Y', strtotime($dn)) ?? '') : '';
              ?>
            </td>
            <td>
              <?php
              $df = $row['data_falecimento'] ?? '';
              echo (!empty($df) && $df !== '0000-00-00') ? htmlspecialchars(date('d/m/Y', strtotime($df)) ?? '') : '';
              ?>
            </td>
            <td><?= htmlspecialchars(ucfirst((string)($row['status'] ?? '')) ?? '') ?></td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr><td colspan="5">Nenhum artista encontrado.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>

  <?php if ($stmt) { $stmt->close(); } ?>

  <!-- Paginação -->
  <?php if ($total_paginas > 1): ?>
    <nav>
      <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
          <li class="page-item <?= ($i === $pagina) ? 'active' : '' ?>">
            <a class="page-link" href="?ordenar=<?= htmlspecialchars($ordenar_por ?? '') ?>&dir=<?= ($direcao === 'DESC') ? 'desc' : 'asc' ?>&pagina=<?= (int) $i ?>">
              <?= (int) $i ?>
            </a>
          </li>
        <?php endfor; ?>
      </ul>
    </nav>
  <?php endif; ?>
</div>

<?php
include_once(__DIR__ . '/../includes_adex/footer.php');
?>
